<%--
 This is the main user interface frame set.  It is presented to the user in
 a new window upon completion of login.  The Connect servlet delivers the
 markup that opens the new window and loads this page.  The URL that loads
 this page is expected to include a query parameter called "uiURL" that is
 the URL to load into the main user interface frame.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.connect.res.connect">
<html>
<head>
   <c:choose>
      <c:when test="${param.uiTitleKey == 'mainuititle_se'}">
         <hmc:title><fmt:message key="mainuititle_se"/></hmc:title>
      </c:when>
      <c:otherwise>
         <hmc:title><fmt:message key="mainuititle"/></hmc:title>
      </c:otherwise>
   </c:choose>
   <meta http-equiv="Cache-Control" content="no-cache">
   <link rel="SHORTCUT ICON" href="/favicon.ico"/>
   <link rel="icon" href="/hmc.png" type="image/png"/>
   <script type="text/javascript" src="/js/task/mainuiFrameset.js"></script>
</head>
<frameset rows="*,0" onunload="processMainWindowUnloaded('<fmt:message key='logoffAppAnnounce'/>')"
                     onbeforeunload="processMainWindowUnloaded('<fmt:message key='logoffAppAnnounce'/>')">
   <frame src="<c:out value='${param.uiURL}'/>" name="hmcmainui"/>

   <frameset cols="50%,50%">

      <frame src="<c:out value='${pageContext.request.contextPath}'/>/taskcontroller"
             scrolling="no" noresize="noresize", frameborder="0"/>

      <frame src="/appletmanager.html" name="hmcAppletManager"
             scrolling="no" noresize="noresize", frameborder="0"/>

   </frameset>

   <noframes>
      <fmt:message key="mustHaveFrames"/>
   </noframes>
</frameset>
</html>
</fmt:bundle>
